(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7346,        368]*)
(*NotebookOutlinePosition[      7982,        390]*)
(*  CellTagsIndexPosition[      7938,        386]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Amplitude and Phase Angle Calculations", "Subtitle"],

Cell[TextData[{
  "These functions assume the independent variable is",
  StyleBox[" ", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ",  and that ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " is Real",
  StyleBox[".", "Input",
    FontWeight->"Plain"]
}], "Text"],

Cell[CellGroupData[{

Cell["Definitions", "Section"],

Cell[CellGroupData[{

Cell["Amplitude", "Subsection"],

Cell[BoxData[
    \(Amplitude[A_. \ Sin[b_]] := Abs[A]\)], "Input"],

Cell[BoxData[
    \(Amplitude[A_. \ Cos[b_]] := Abs[A]\)], "Input"],

Cell[BoxData[
    \(Amplitude[
        A_. \ Sin[b_] + \ B_. \ Cos[b_]] := \@\(A\^2 + B\^2\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Sine Phase Angle", "Subsection"],

Cell[BoxData[
    \(SinePhaseAngle[A_. \ Sin[b_. \ t + c_. ]] := 
      c + ArcTan[A, 0]\)], "Input"],

Cell[BoxData[
    \(SinePhaseAngle[A_. \ Cos[b_. \ t + c_. ]] := 
      c + ArcTan[0, A]\)], "Input"],

Cell[BoxData[
    \(SinePhaseAngle[A_. \ Sin[b_] + B_. \ Cos[b_]] := 
      ArcTan[A, B]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Cosine Phase Angle", "Subsection"],

Cell[BoxData[
    \(CosinePhaseAngle[A_. \ Sin[b_. \ t + c_. ]] := 
      c - ArcTan[0, A]\)], "Input"],

Cell[BoxData[
    \(CosinePhaseAngle[A_. \ Cos[b_. \ t + c_. ]] := 
      c + ArcTan[A, 0]\)], "Input"],

Cell[BoxData[
    \(CosinePhaseAngle[A_. \ Sin[b_] + B_. \ Cos[b_]] := 
      ArcTan[B, \(-A\)]\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Section"],

Cell[CellGroupData[{

Cell["1) Pure Sine", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t_] = \(-2\) Sin[2  t]\)], "Input"],

Cell[BoxData[
    \(\(-2\)\ Sin[2\ t]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = Amplitude[y[t]]\)], "Input"],

Cell[BoxData[
    \(2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(spa = SinePhaseAngle[y[t]]\)], "Input"],

Cell[BoxData[
    \(\[Pi]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cpa = CosinePhaseAngle[y[t]]\)], "Input"],

Cell[BoxData[
    \(\[Pi]\/2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check.", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t] \[Equal] A\ Sin[2  t + spa]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t] \[Equal] A\ Cos[2  t + cpa]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2) Exponential in coefficient", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t_] = \(-2\) Exp[\(-3\) t] Sin[2  t]\)], "Input"],

Cell[BoxData[
    \(\(-2\)\ \[ExponentialE]\^\(\(-3\)\ t\)\ Sin[2\ t]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(expr = Exp[\(-3\) t]\)], "Input"],

Cell[BoxData[
    \(\[ExponentialE]\^\(\(-3\)\ t\)\)], "Output"]
}, Closed]],

Cell["Declare t to be Real.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(t /: Re[t] = t\)], "Input"],

Cell[BoxData[
    \(t\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(t /: Im[t] = 0\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = Amplitude[y[t]]\)], "Input"],

Cell[BoxData[
    \(2\ \[ExponentialE]\^\(\(-3\)\ t\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(spa = SinePhaseAngle[y[t]/expr]\)], "Input"],

Cell[BoxData[
    \(\[Pi]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cpa = CosinePhaseAngle[y[t]/expr]\)], "Input"],

Cell[BoxData[
    \(\[Pi]\/2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check.", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t] \[Equal] A\ Sin[2  t + spa]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t] \[Equal] A\ Cos[2  t + cpa]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["3) Sine, Cosine mix", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t_] = \(-3\) Sin[2  t] + 4  Cos[2  t]\)], "Input"],

Cell[BoxData[
    \(4\ Cos[2\ t] - 3\ Sin[2\ t]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = Amplitude[y[t]]\)], "Input"],

Cell[BoxData[
    \(5\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(spa = SinePhaseAngle[y[t]]\)], "Input"],

Cell[BoxData[
    \(\[Pi] - ArcTan[4\/3]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cpa = CosinePhaseAngle[y[t]]\)], "Input"],

Cell[BoxData[
    \(ArcTan[3\/4]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check.", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t] \[Equal] A\ Sin[2  t + spa]\)], "Input"],

Cell[BoxData[
    \(4\ Cos[2\ t] - 
        3\ Sin[2\ t] == \(-5\)\ Sin[2\ t - ArcTan[4\/3]]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t] \[Equal] A\ Sin[2  t + spa] // Simplify\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t] \[Equal] A\ Cos[2  t + cpa]\)], "Input"],

Cell[BoxData[
    \(4\ Cos[2\ t] - 3\ Sin[2\ t] == 5\ Cos[2\ t + ArcTan[3\/4]]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t] \[Equal] A\ Cos[2  t + cpa] // Simplify\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowSize->{520, 624},
WindowMargins->{{54, Automatic}, {Automatic, 3}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 58, 0, 65, "Subtitle"],
Cell[1837, 55, 287, 11, 32, "Text"],

Cell[CellGroupData[{
Cell[2149, 70, 30, 0, 56, "Section"],

Cell[CellGroupData[{
Cell[2204, 74, 31, 0, 46, "Subsection"],
Cell[2238, 76, 67, 1, 27, "Input"],
Cell[2308, 79, 67, 1, 27, "Input"],
Cell[2378, 82, 105, 2, 35, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[2520, 89, 38, 0, 46, "Subsection"],
Cell[2561, 91, 101, 2, 27, "Input"],
Cell[2665, 95, 101, 2, 27, "Input"],
Cell[2769, 99, 101, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[2907, 106, 40, 0, 46, "Subsection"],
Cell[2950, 108, 103, 2, 43, "Input"],
Cell[3056, 112, 103, 2, 43, "Input"],
Cell[3162, 116, 108, 2, 43, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3319, 124, 27, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[3371, 128, 34, 0, 46, "Subsection"],

Cell[CellGroupData[{
Cell[3430, 132, 57, 1, 27, "Input"],
Cell[3490, 135, 51, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3578, 141, 52, 1, 27, "Input"],
Cell[3633, 144, 35, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3705, 150, 59, 1, 27, "Input"],
Cell[3767, 153, 39, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3843, 159, 61, 1, 27, "Input"],
Cell[3907, 162, 42, 1, 39, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3986, 168, 31, 0, 42, "Subsubsection"],

Cell[CellGroupData[{
Cell[4042, 172, 65, 1, 27, "Input"],
Cell[4110, 175, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4185, 181, 65, 1, 27, "Input"],
Cell[4253, 184, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4352, 192, 51, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[4428, 196, 71, 1, 27, "Input"],
Cell[4502, 199, 83, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4622, 205, 53, 1, 27, "Input"],
Cell[4678, 208, 64, 1, 29, "Output"]
}, Closed]],
Cell[4757, 212, 37, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[4819, 216, 47, 1, 27, "Input"],
Cell[4869, 219, 35, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4941, 225, 47, 1, 27, "Input"],
Cell[4991, 228, 35, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5063, 234, 52, 1, 27, "Input"],
Cell[5118, 237, 67, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5222, 243, 64, 1, 27, "Input"],
Cell[5289, 246, 39, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5365, 252, 66, 1, 27, "Input"],
Cell[5434, 255, 42, 1, 39, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5513, 261, 31, 0, 42, "Subsubsection"],

Cell[CellGroupData[{
Cell[5569, 265, 65, 1, 27, "Input"],
Cell[5637, 268, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5712, 274, 65, 1, 27, "Input"],
Cell[5780, 277, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5879, 285, 41, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[5945, 289, 72, 1, 27, "Input"],
Cell[6020, 292, 61, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6118, 298, 52, 1, 24, "Input"],
Cell[6173, 301, 35, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6245, 307, 59, 1, 24, "Input"],
Cell[6307, 310, 54, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6398, 316, 61, 1, 24, "Input"],
Cell[6462, 319, 46, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6545, 325, 31, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[6601, 329, 65, 1, 27, "Input"],
Cell[6669, 332, 106, 2, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6812, 339, 77, 1, 24, "Input"],
Cell[6892, 342, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6967, 348, 65, 1, 24, "Input"],
Cell[7035, 351, 92, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7164, 357, 77, 1, 24, "Input"],
Cell[7244, 360, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

